#!/bin/sh

case $0 in
        /*) rootdir=$(cd "$(dirname $0)"; pwd); ;;
        *)  rootdir=$(cd "$(dirname $(pwd)/$0)"; pwd); ;;
esac

esxi_H="${1}"
esxi_U="${2}"
esxi_P="${3}"
sandbox_U="${4}"
sandbox_P="${5}"
sandbox_vmpath="${6}"
sandbox_vmname_prefix="${7}"
sandbox_count="${8}"
sandbox_default_ipaddr="${9}"
os_start_time="${10}"

setup_logfile="${rootdir}/setup.log"
setup_logcount=10;
setup_logsize=10;	#in meta bytes

setup_message ()
{
	log_date=$(date '+%Y/%m/%d %H:%M:%S');

	if [ $# -eq 0 ]; then
		awk "{ printf(\"%s - %s\\n\", strftime(\"%Y/%m/%d %H:%M:%S\"), \$0) >> \"${setup_logfile}\"; }"
	else
		echo "${log_date} - $*" >> ${setup_logfile}
	fi
}

setup_gettext ()
{
	gettext "Setup" "$1"
}

setup_printf ()
{
	printf "$@";
}

setup_rotate_log ()
{
	logfile=$1;
	count=$2;

	ndx=$(( ${count} - 1 ))

	rm -f "${logfile}.${ndx}";

	while [ ${ndx} -ge 1 ]; do
		mv -f "${logfile}.$(( ${ndx} - 1 ))" "${logfile}.${ndx}";
		ndx=$(( ${ndx} - 1 ));
	done

	mv -f "${logfile}" "${logfile}.${ndx}";
	touch "${logfile}";
}

setup_check_logs ()
{
	logsize=$(ls -1 "${setup_logfile}" | awk '{printf("%d", $5 / 1024 / 1024);}');
	if [ ${logsize} -ge ${setup_logsize} ]; then
		setup_rotate_log "${setup_logfile}" ${setup_logcount};
	fi
}

setup_ping ()
{
	ipaddr=$1;
	ping -c 1 ${ipaddr} 2>&1 >/dev/null
	return $?;
}

sandbox_clone () {
    sandbox_vmstorage="${sandbox_vmpath%/*/*}";
    for i in `seq 1 ${sandbox_count}` ; do
        vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmstorage}/${sandbox_vmname_prefix}${i}/${sandbox_vmname_prefix}${i}.vmx" start 2>&1 | setup_message;

        cnt=${os_start_time};
	while [ ${cnt} -ge 1 ]; do
            # Check if OS is up
            if setup_ping ${sandbox_default_ipaddr}; then
                setup_message "Sandbox_${i} OS is up!!";
                break;
            fi
            cnt=$(( ${cnt} - 1 ));
            sleep 1;
	done

        # Wait for samba service up
        sleep 30;

        sed -i \
        -e "s,^\\(.*\\<sandbox_ip\\>[^=]*=\\s*\\).*\$,\\1\"1.1.2.${i}\"," \
        "${rootdir}/ip.txt"

        # create sandcaslte src log folder
        [ ! -e ${rootdir}/c_dir ]  && mkdir ${rootdir}/c_dir;

	# connnect shared folder for 5 times
        setup_message "mount -t cifs -o username=${sandbox_U},password=${sandbox_P} //${sandbox_default_ipaddr}/c$ ${rootdir}/c_dir";
        if mount -t cifs -o username=${sandbox_U},password=${sandbox_P} //${sandbox_default_ipaddr}/c$ ${rootdir}/c_dir 2>&1 >/dev/null; then
            setup_message "Sandbox_${i} Mount Success!!";
            if [ ${i} -ne 1 ]; then
                cp  "${rootdir}/ip.txt" "${rootdir}/c_dir" 2>&1 | setup_message;
            fi

            umount "${rootdir}/c_dir" 2>&1 | setup_message;
            setup_message "Sandbox_${i} Umount Success!!";
         
			retry_count=3
			while [ "${retry_count}" -ge 1 ];
			do
				if [ ${i} -ne 1 ]; then
					setup_message "Sandbox_${i} Reinsert CD!!";
					vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmstorage}/${sandbox_vmname_prefix}${i}/${sandbox_vmname_prefix}${i}.vmx" disconnectdevice "CD/DVD drive 1" 2>&1 | setup_message;
					sleep 2	# take a rest to avoid timing issue
					vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmstorage}/${sandbox_vmname_prefix}${i}/${sandbox_vmname_prefix}${i}.vmx" connectdevice "CD/DVD drive 1" 2>&1 | setup_message;
				fi
			
				cnt=30;
				while [ ${cnt} -ge 1 ]; do
					# Check if ip is reset
					if setup_ping "1.1.2.${i}"; then
						setup_message "Sandbox_${i} ip is reset!!";
						break;
					fi
					cnt=$(( ${cnt} - 1 ));
					sleep 1;
				done
				
				if [ "${cnt}" -ge 1 ]; then
					break
				else
					if [ "${retry_count}" -eq 1 ]; then
						exit 1
					fi
				fi
				
				retry_count=$((${retry_count}-1))
			done

            setup_message "Sandbox_${i} Eject CD!!";
            vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmstorage}/${sandbox_vmname_prefix}${i}/${sandbox_vmname_prefix}${i}.vmx" disconnectdevice "CD/DVD drive 1" 2>&1 | setup_message;

            vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmstorage}/${sandbox_vmname_prefix}${i}/${sandbox_vmname_prefix}${i}.vmx" createsnapshot init sandbox_${i}_init 1 1 2>&1 | setup_message;
            vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmstorage}/${sandbox_vmname_prefix}${i}/${sandbox_vmname_prefix}${i}.vmx" stop hard 2>&1 | setup_message;
        else
            setup_message "Sandbox_${i} Counldn't Mount!!";
            vmware-cmd --username "${esxi_U}" --password "${esxi_P}" --server "${esxi_H}" "${sandbox_vmstorage}/${sandbox_vmname_prefix}${i}/${sandbox_vmname_prefix}${i}.vmx" stop hard 2>&1 | setup_message;
            setup_message "setup_sandbox exit with 1 !!";
            exit 1;
        fi
    done
}

setup_check_logs;
sandbox_clone;
setup_message "setup_sandbox exit with 0 !!";
exit 0;
